#ifndef _RENDER_
#define _RENDER_
typedef struct Render Render;
#include "common.h"
#include "game.h"
#include "isometric.h"
#include "main.h"
#include "debug.h"
#include "platform.h"
#include "menu.h"
#include "map.h"
struct Render {
    bool was_setup;
    LandColor background_color;
    LandStream * music;
    int song;
    LandAtlas * atlas;
    LandShader * shader;
};
Render* render_global(void);
void render_setup(void);
void play_song(void);
void song_volume(void);
void render(Game * g, float w, float h);
void render_block_scaled(Block * self, Viewport * viewport, double scaled);
void render_block(Block * self, Viewport * viewport);
void render_blocks(Blocks * blocks, Viewport * viewport);
void render_block_speech_bubbles(Blocks * blocks, Viewport * viewport);
void render_set_shaders(void);
#endif
